//
//  Music.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

public protocol PitchProtocol {
    
    /// The sonic frequency of this Pitch
    var frequency: Double { get }
    
}

public protocol NoteProtocol {
    associatedtype PitchType: PitchProtocol
    
    /// Play this Note through a ToneOutput
    var tone: Tone { get }
    
    /// The duration of this Note as a multiple of quarter notes, e.g., a half note would equal 2.0, an eight note
    var length: Float { get }
    
    /// Length of the smallest Note supported
    static var shortestSupportedNoteLength: Float { get }
    
    /// Subdivide into a series pitches, according to the shortest supported note
    func subdivide() -> [PitchType]
}





// TODO: Complete Notes by conforming to NoteProtocol
public enum Note : NoteProtocol {
    case quarter(Pitch)
    case half(Pitch)
    
    /// Play this Note through a ToneOutput
    public var tone: Tone {
        // FIXME: Placeholder
        return Tone(pitch: 440.0, volume: 0.3)
    }
    
    /// The duration of this Note as a multiple of quarter notes, e.g., a half note would equal 2.0, an eight note
    public var length: Float {
        // FIXME: Placeholder
        return 0.0
    }
    
    /// Length of the smallest Note supported
    public static var shortestSupportedNoteLength: Float {
        // FIXME: Placeholder
        return -1.0
    }
    
    /// Subdivide into a series pitches, according to the shortest supported note
    public func subdivide() -> [Pitch] {
        // FIXME: Placholder
        return []
    }
}



// TODO: Complete Pitch by conforming to PitchProtocol
public enum Pitch : Double, PitchProtocol {
    case c3 = 261.63
    case d3 = 293.66
    case e3 = 329.63
    case f3 = 349.23
    case g3 = 392.00
    case a4 = 440.0
    case b4 = 493.88
    case c4 = 523.25
    
    /// The sonic frequency of this Pitch
    public var frequency: Double {
        // FIXME: Placeholder
        return 0.0
    }
}
